/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.Serializable;
import java.util.Date;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCAlignerLayout;
import jclass.bwt.JCLabel;
import jclass.bwt.JCTextComponent;
import jclass.bwt.JCTextField;
import jclass.chart.JCAxis;
import jclass.chart.customizer.JCEnumEditor;
import jclass.chart.customizer.JCPropertyPage;

public class TimeLabelPage
extends JCPropertyPage
implements JCActionListener {
    private JCTextField baseField;
    private JCTextField formatField;
    private JCEnumEditor unitCombo;
    static String defaultString = "default";
    private final long SECONDS = 1000L;
    private final long MINUTES = 60000L;
    private final long HOURS = 3600000L;
    private final long DAYS = 86400000L;
    private final long WEEKS = 604800000L;
    private final long MONTHS = 2678400000L;
    private final long YEARS = 31536000000L;
    JCAxis target;

    public void init() {
        this.setLayout(new JCAlignerLayout(2, 3, 3));
        this.add(new JCLabel("Base Time:"));
        this.baseField = new JCTextField("", 20);
        this.baseField.setBackground(JCPropertyPage.textBG);
        this.baseField.addActionListener(this);
        this.baseField.setBackground(JCPropertyPage.textBG);
        this.add(this.baseField);
        this.add(new JCLabel("Format:"));
        this.formatField = new JCTextField("", 20);
        this.formatField.addActionListener(this);
        this.formatField.setBackground(JCPropertyPage.textBG);
        this.add(this.formatField);
        this.add(new JCLabel("Units:"));
        long[] lArray = JCAxis.timeUnit_values;
        int[] nArray = new int[lArray.length];
        int n = 0;
        while (n < lArray.length) {
            nArray[n] = (int)lArray[n];
            ++n;
        }
        this.unitCombo = new JCEnumEditor(JCAxis.timeUnit_strings, nArray, "timeUnitCombo");
        this.unitCombo.getTextField().setColumns(8);
        this.unitCombo.getTextField().setBackground(JCPropertyPage.textBG);
        this.unitCombo.addPropertyChangeListener(this);
        this.add(this.unitCombo);
    }

    public Object getObject() {
        return this.target;
    }

    public void setObject(Object object) {
        if (object instanceof JCAxis) {
            this.target = (JCAxis)object;
            Date date = this.target.getTimeBase();
            String string = date.toString();
            if (string.indexOf("Time") != -1) {
                string = date.toGMTString();
            }
            ((JCTextComponent)this.baseField).setText(string);
            String string2 = this.target.getTimeFormatIsDefault() ? new String(String.valueOf(this.target.getTimeFormat()) + " (" + defaultString + ")") : new String(this.target.getTimeFormat());
            ((JCTextComponent)this.formatField).setText(string2);
            this.unitCombo.setValue(new Integer((int)this.target.getTimeUnit()));
        }
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (this.target == null) {
            return;
        }
        if (jCActionEvent.getSource() instanceof JCTextField) {
            JCTextField jCTextField = (JCTextField)jCActionEvent.getSource();
            if (jCTextField == this.baseField) {
                long l = Date.parse(jCTextField.getText());
                this.target.setTimeBase(new Date(l));
            } else if (jCTextField == this.formatField) {
                String string = jCTextField.getText();
                if (string.equalsIgnoreCase(new String("")) || string.indexOf(defaultString) >= 0) {
                    this.target.setTimeFormatIsDefault(true);
                } else {
                    this.target.setTimeFormat(jCTextField.getText());
                }
            }
            this.setObject(this.target);
        }
    }

    public void propertyChanged(Object object, Object object2) {
        if (this.target == null) {
            return;
        }
        if (object == this.unitCombo) {
            this.target.setTimeUnit(this.convertTimeUnitToLong((Integer)object2));
        }
        this.setObject();
    }

    private long convertTimeUnitToLong(int n) {
        if (n == 1471228928) {
            return 31536000000L;
        }
        if (n == -1616567296) {
            return 2678400000L;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Frame frame;
        Serializable serializable;
        try {
            serializable = Class.forName("jclass.chart.demos.DemoFrame");
            frame = (Frame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            frame = new Frame();
        }
        frame.setTitle("Time Axis Property Page");
        serializable = new TimeLabelPage();
        ((Component)serializable).setBackground(Color.lightGray);
        ((TimeLabelPage)serializable).init();
        frame.add((Component)serializable);
        frame.pack();
        Dimension dimension = ((Container)serializable).preferredSize();
        frame.resize(dimension.width + 10, dimension.height + 30);
        frame.show();
    }
}

